

<div class="container mt-5">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card mb-4">
                <?php if($media_item->file_type == 'image'): ?>
                    <img src="<?= base_url('assets/uploads/media/' . $media_item->file_path) ?>" 
                         class="card-img-top" 
                         alt="<?= $media_item->title ?>" 
                         style="max-height: 500px; object-fit: cover;">
                <?php elseif($media_item->file_type == 'video'): ?>
                    <video controls class="card-img-top" style="max-height: 500px; object-fit: cover;">
                        <source src="<?= base_url('assets/uploads/media/' . $media_item->file_path) ?>" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                <?php else: ?>
                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 300px;">
                        <i class="fa fa-file fa-5x text-muted"></i>
                    </div>
                <?php endif; ?>

                <div class="card-body">
                    <h2 class="card-title"><?= $media_item->title ?></h2>
                    <p class="card-text text-muted">
                        <small>
                            Category: <?= $media_item->category_name ?> | 
                            Type: <?= ucfirst($media_item->file_type) ?> | 
                            Uploaded: <?= date('F d, Y', strtotime($media_item->created_at)) ?>
                        </small>
                    </p>

                    <?php if(!empty($media_item->description)): ?>
                        <div class="mt-3">
                            <h4>Description</h4>
                            <p><?= nl2br(htmlspecialchars($media_item->description)) ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($media_item->tags)): ?>
                        <div class="mt-3">
                            <h4>Tags</h4>
                            <?php $tags = explode(',', $media_item->tags); ?>
                            <?php foreach($tags as $tag): ?>
                                <span class="badge badge-secondary mr-1"><?= trim($tag) ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <div class="mt-4">
                        <a href="<?= site_url('media') ?>" class="btn btn-outline-primary">
                            Back to Media Gallery
                        </a>
                        <?php if($media_item->file_type != 'document'): ?>
                            <a href="<?= base_url('assets/uploads/media/' . $media_item->file_path) ?>" 
                               class="btn btn-primary" 
                               download>
                                Download
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if(!empty($related_media)): ?>
                <div class="card">
                    <div class="card-header">
                        <h4>Related Media</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php foreach($related_media as $related): ?>
                                <div class="col-md-3 mb-3">
                                    <a href="<?= site_url('media/view/' . $related->id) ?>" class="text-decoration-none">
                                        <?php if($related->file_type == 'image'): ?>
                                            <img src="<?= base_url('assets/uploads/media/' . $related->file_path) ?>" 
                                                 class="img-fluid rounded" 
                                                 alt="<?= $related->title ?>" 
                                                 style="height: 150px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-light d-flex align-items-center justify-content-center rounded" 
                                                 style="height: 150px;">
                                                <i class="fa fa-file fa-3x text-muted"></i>
                                            </div>
                                        <?php endif; ?>
                                        <p class="text-center mt-2"><?= $related->title ?></p>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>